(function(exports) {
    
exports.load_script = function(src) {
	return new Promise(function(resolve, reject) {
		let script = document.createElement('script')
		script.src = src

		script.onload = () => resolve(script)
		script.onerror = () => reject(new Error(`Ошибка загрузки скрипта ${src}`))

		document.head.append(script)
	})
}

exports.response_ready = function(response_text) {
	//console.log(response_text)
	let values = exports.get_response_values_from_text(response_text)
	return new Promise(function(resolve, reject) {
		resolve(values);
	})
}

exports.get_response_values_from_text = function(text) {
	let response_values = []
	let responseLines = text.split('\n')
	let responseLine = responseLines[0]
	response_values = responseLine.split('&#&')
	response_values.pop()
	//console.log('response_values: ' + response_values.length)

	return response_values
}

exports.get_progress_bar = function(div_id, current, max, bar_lenght=50) {                   
	let progress_bar = '|'
	for (let i=0; i<bar_lenght; i++)
	{
		if (i < current/max*bar_lenght)
		{
			progress_bar += '#'
		}
		else
		{
			progress_bar += '-'
		}
	}
	progress_bar += `|${Math.floor(current/max*100)}%`
	$(div_id).html(progress_bar).css("font-family", "monospace")
}

exports.get_set_od_data_query_unit = function (index, value) {
	let value_str = `${value}`
	return `0x${index}=${value_str.replaceAll("&","%26")}`
}

exports.ip2string = function(ip_int)
{
	let ip_arr = exports.ip2array(ip_int)
	let str_ip = ""

	str_ip += ip_arr[0].toString()
	str_ip += '.'
	str_ip += ip_arr[1].toString()
	str_ip += '.'
	str_ip += ip_arr[2].toString()
	str_ip += '.'
	str_ip += ip_arr[3].toString()
	return str_ip
}

exports.ip2array = function(ip_int)
{
	let arr = []
	let ip_big_int = BigInt(ip_int)
	arr[3] = (ip_big_int >> 24n) & 0xFFn
	arr[2] = (ip_big_int >> 16n) & 0xFFn
	arr[1] = (ip_big_int >> 8n) & 0xFFn
	arr[0] = (ip_big_int >> 0n) & 0xFFn
	return arr
}

exports.string2int_ip = function(str)
{
	let ip_int_arr = [0,0,0,0]
	let ip_str_arr = str.split(".")
	if (ip_str_arr.length != 4)
	{
		return 0
	}
	
	for(i=0; i<4; i++)
	{
		ip_int_arr[i] = parseInt(ip_str_arr[i])
	}
	return exports.array2int_ip(ip_int_arr)
}

exports.array2int_ip = function(ip_arr)
{
	//let ip = 0 >>> 0
	let ip = ((((ip_arr[3] & 0xFF) << 24) >>> 0)
			| (((ip_arr[2] & 0xFF) << 16) >>> 0)
			| (((ip_arr[1] & 0xFF) << 8) >>> 0)
			| (((ip_arr[0] & 0xFF) << 0) >>> 0)) >>> 0
	return ip
}

exports.change_checked = function(ctrl, value)
{
	if (`${value}` == "1")
	{
		$(ctrl).prop('checked', true)
	}
	else if (`${value}` == "0")
	{
		$(ctrl).prop('checked', false)
	}
}

exports.checked2string = function(ctrl)
{
	if (ctrl.is(':checked') == true)
	{
		return "1";
	}
	else
	{
		return "0";
	}
}

})(this.utils = {});